const fs = require('fs');
const axios = require('axios');
const fse = require('fs-extra');
const path = require('path');

const har = JSON.parse(fs.readFileSync('./har/input.har', 'utf8'));
const outputFolder = './assets';

(async () => {
  for (const entry of har.log.entries) {
    const url = entry.request.url;
    const mime = entry.response.content.mimeType || '';

    if (/text|javascript|css|image|font|svg/.test(mime)) {
      try {
        const res = await axios.get(url, { responseType: 'arraybuffer' });
        const pathname = new URL(url).pathname;
        const filePath = path.join(outputFolder, pathname);
        await fse.outputFile(filePath, res.data);
        console.log(`✔️  Saved: ${pathname}`);
      } catch (e) {
        console.warn(`❌ Failed: ${url}`);
      }
    }
  }
})();
