<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;

/* @bundles/SmsBundle/Controller/Api/SmsApiController.php */
class __TwigTemplate_d1cfcbe8a6bacd4acca891cbc07b2e7cc1ad8343daa409777a3f58d157f70cd1 extends Template
{
    private $source;
    private $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = [])
    {
        $macros = $this->macros;
        // line 1
        echo "<?php

namespace Mautic\\SmsBundle\\Controller\\Api;

use Mautic\\ApiBundle\\Controller\\CommonApiController;
use Mautic\\LeadBundle\\Controller\\LeadAccessTrait;
use Mautic\\SmsBundle\\Model\\SmsModel;
use Symfony\\Component\\HttpFoundation\\JsonResponse;
use Symfony\\Component\\HttpFoundation\\Response;
use Symfony\\Component\\HttpKernel\\Event\\FilterControllerEvent;

/**
 * Class SmsApiController.
 */
class SmsApiController extends CommonApiController
{
    use LeadAccessTrait;

    /**
     * @var SmsModel
     */
    protected \$model;

    /**
     * {@inheritdoc}
     */
    public function initialize(FilterControllerEvent \$event)
    {
        \$this->model           = \$this->getModel('sms');
        \$this->entityClass     = 'Mautic\\SmsBundle\\Entity\\Sms';
        \$this->entityNameOne   = 'sms';
        \$this->entityNameMulti = 'smses';

        parent::initialize(\$event);
    }

    /**
     * @param \$id
     * @param \$contactId
     *
     * @return JsonResponse|Response
     */
    public function sendAction(\$id, \$contactId)
    {
        if (!\$this->get('mautic.sms.transport_chain')->getEnabledTransports()) {
            return new JsonResponse(json_encode(['error' => ['message' => 'SMS transport is disabled.', 'code' => Response::HTTP_EXPECTATION_FAILED]]));
        }

        \$message = \$this->model->getEntity((int) \$id);

        if (is_null(\$message)) {
            return \$this->notFound();
        }

        \$contact = \$this->checkLeadAccess(\$contactId, 'edit');

        if (\$contact instanceof Response) {
            return \$this->accessDenied();
        }

        \$this->get('monolog.logger.mautic')
             ->addDebug(\"Sending SMS #{\$id} to contact #{\$contactId}\", ['originator' => 'api']);

        try {
            \$response = \$this->model->sendSms(\$message, \$contact, ['channel' => 'api'])[\$contact->getId()];
        } catch (\\Exception \$e) {
            \$this->get('monolog.logger.mautic')->addError(\$e->getMessage(), ['error' => (array) \$e]);

            return new Response('Interval server error', Response::HTTP_INTERNAL_SERVER_ERROR);
        }

        \$success = !empty(\$response['sent']);

        if (!\$success) {
            \$this->get('monolog.logger.mautic')->addError('Failed to send SMS.', ['error' => \$response['status']]);
        }

        \$view = \$this->view(
            [
                'success' => \$success,
                'status'  => \$this->get('translator')->trans(\$response['status']),
                'result'  => \$response,
                'errors'  => \$success ? [] : [['message' => \$response['status']]],
            ],
            Response::HTTP_OK  //  200 - is legacy, we cannot change it yet
        );

        return \$this->handleView(\$view);
    }
}
";
    }

    public function getTemplateName()
    {
        return "@bundles/SmsBundle/Controller/Api/SmsApiController.php";
    }

    public function getDebugInfo()
    {
        return array (  37 => 1,);
    }

    public function getSourceContext()
    {
        return new Source("", "@bundles/SmsBundle/Controller/Api/SmsApiController.php", "/var/www/mautic/app/bundles/SmsBundle/Controller/Api/SmsApiController.php");
    }
}
