<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;

/* @bundles/CoreBundle/Form/EventListener/FormExitSubscriber.php */
class __TwigTemplate_ec5d941806d44f8d16f5bfa7a4a4dab15c79d43fad515bb7973b004802df8877 extends Template
{
    private $source;
    private $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = [])
    {
        $macros = $this->macros;
        // line 1
        echo "<?php

namespace Mautic\\CoreBundle\\Form\\EventListener;

use Symfony\\Component\\EventDispatcher\\EventSubscriberInterface;
use Symfony\\Component\\Form\\Extension\\Core\\Type\\HiddenType;
use Symfony\\Component\\Form\\FormEvent;
use Symfony\\Component\\Form\\FormEvents;

/**
 * Class FormExitSubscriber.
 */
class FormExitSubscriber implements EventSubscriberInterface
{
    /**
     * @var \\Mautic\\CoreBundle\\Model\\CommonModel
     */
    private \$model;

    /**
     * @var array
     */
    private \$options;

    /**
     * @param \\Mautic\\CoreBundle\\Model\\CommonModel \$model
     * @param array                                \$options
     */
    public function __construct(\$model, \$options = [])
    {
        \$this->model   = \$model;
        \$this->options = \$options;
    }

    /**
     * {@inheritdoc}
     */
    public static function getSubscribedEvents()
    {
        return [FormEvents::PRE_SET_DATA => 'preSetData'];
    }

    public function preSetData(FormEvent \$event)
    {
        \$id = !empty(\$this->options['data']) ? \$this->options['data']->getId() : 0;
        if (\$id && empty(\$this->options['ignore_formexit'])) {
            //add a hidden field that is used exclusively to warn a user to use save/cancel to exit a form
            \$form = \$event->getForm();

            \$form->add(
                'unlockModel',
                HiddenType::class,
                [
                    'data'     => \$this->model,
                    'required' => false,
                    'mapped'   => false,
                    'attr'     => ['class' => 'form-exit-unlock-model'],
                ]
            );

            \$form->add(
                'unlockId',
                HiddenType::class,
                [
                    'data'     => \$id,
                    'required' => false,
                    'mapped'   => false,
                    'attr'     => ['class' => 'form-exit-unlock-id'],
                ]
            );

            if (isset(\$this->options['unlockParameter'])) {
                \$form->add(
                    'unlockParameter',
                    HiddenType::class,
                    [
                        'data'     => \$this->options['unlockParameter'],
                        'required' => false,
                        'mapped'   => false,
                        'attr'     => ['class' => 'form-exit-unlock-parameter'],
                    ]
                );
            }
        }
    }
}
";
    }

    public function getTemplateName()
    {
        return "@bundles/CoreBundle/Form/EventListener/FormExitSubscriber.php";
    }

    public function getDebugInfo()
    {
        return array (  37 => 1,);
    }

    public function getSourceContext()
    {
        return new Source("", "@bundles/CoreBundle/Form/EventListener/FormExitSubscriber.php", "/var/www/mautic/app/bundles/CoreBundle/Form/EventListener/FormExitSubscriber.php");
    }
}
