<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;

/* @bundles/FormBundle/Form/Type/FormFieldFileType.php */
class __TwigTemplate_33eb6b013527a4a7310170411cd5f0686f1d2b9fec7462869a6e33e5ba6528c3 extends Template
{
    private $source;
    private $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = [])
    {
        $macros = $this->macros;
        // line 1
        echo "<?php

namespace Mautic\\FormBundle\\Form\\Type;

use Mautic\\CoreBundle\\Form\\DataTransformer\\ArrayStringTransformer;
use Mautic\\CoreBundle\\Form\\Type\\YesNoButtonGroupType;
use Mautic\\CoreBundle\\Helper\\CoreParametersHelper;
use Mautic\\CoreBundle\\Helper\\FileHelper;
use Mautic\\FormBundle\\Validator\\Constraint\\FileExtensionConstraint;
use Symfony\\Component\\Form\\AbstractType;
use Symfony\\Component\\Form\\Extension\\Core\\Type\\TextareaType;
use Symfony\\Component\\Form\\Extension\\Core\\Type\\TextType;
use Symfony\\Component\\Form\\FormBuilderInterface;
use Symfony\\Component\\Translation\\TranslatorInterface;
use Symfony\\Component\\Validator\\Constraints\\LessThanOrEqual;

/**
 * Class FormFieldFileType.
 */
class FormFieldFileType extends AbstractType
{
    const PROPERTY_ALLOWED_FILE_EXTENSIONS = 'allowed_file_extensions';
    const PROPERTY_ALLOWED_FILE_SIZE       = 'allowed_file_size';
    const PROPERTY_PREFERED_PROFILE_IMAGE  = 'profile_image';

    /** @var CoreParametersHelper */
    private \$coreParametersHelper;

    /**
     * @var TranslatorInterface
     */
    private \$translator;

    public function __construct(CoreParametersHelper \$coreParametersHelper, TranslatorInterface \$translator)
    {
        \$this->coreParametersHelper = \$coreParametersHelper;
        \$this->translator           = \$translator;
    }

    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface \$builder, array \$options)
    {
        if (empty(\$options['data'][self::PROPERTY_ALLOWED_FILE_EXTENSIONS])) {
            \$options['data'][self::PROPERTY_ALLOWED_FILE_EXTENSIONS] = \$this->coreParametersHelper->get('allowed_extensions');
        }
        if (empty(\$options['data'][self::PROPERTY_ALLOWED_FILE_SIZE])) {
            \$options['data'][self::PROPERTY_ALLOWED_FILE_SIZE] = \$this->coreParametersHelper->get('max_size');
        }

        \$arrayStringTransformer = new ArrayStringTransformer();
        \$builder->add(
            \$builder->create(
                self::PROPERTY_ALLOWED_FILE_EXTENSIONS,
                TextareaType::class,
                [
                    'label'      => 'mautic.form.field.file.allowed_extensions',
                    'label_attr' => ['class' => 'control-label'],
                    'required'   => false,
                    'attr'       => [
                        'class'   => 'form-control',
                        'tooltip' => 'mautic.form.field.file.tooltip.allowed_extensions',
                    ],
                    'data'        => \$options['data'][self::PROPERTY_ALLOWED_FILE_EXTENSIONS],
                    'constraints' => [new FileExtensionConstraint()],
                ]
            )->addViewTransformer(\$arrayStringTransformer)
        );

        \$maxUploadSize = FileHelper::getMaxUploadSizeInMegabytes();
        \$builder->add(
            self::PROPERTY_ALLOWED_FILE_SIZE,
            TextType::class,
            [
                'label'      => 'mautic.form.field.file.allowed_size',
                'label_attr' => ['class' => 'control-label'],
                'required'   => false,
                'attr'       => [
                    'class'   => 'form-control',
                    'tooltip' => \$this->translator->trans('mautic.form.field.file.tooltip.allowed_size', ['%uploadSize%' => \$maxUploadSize]),
                ],
                'data'        => \$options['data'][self::PROPERTY_ALLOWED_FILE_SIZE],
                'constraints' => [new LessThanOrEqual(['value' => \$maxUploadSize])],
            ]
        );

        \$builder->add(
            'public',
            YesNoButtonGroupType::class,
            [
                'label' => 'mautic.form.field.file.public',
            ]
        );

        \$builder->add(
            self::PROPERTY_PREFERED_PROFILE_IMAGE,
            YesNoButtonGroupType::class,
            [
                'label'       => 'mautic.form.field.file.set_as_profile_image',
                'data'        => isset(\$options['data'][self::PROPERTY_PREFERED_PROFILE_IMAGE]) ? \$options['data'][self::PROPERTY_PREFERED_PROFILE_IMAGE] : false,
            ]
        );
    }
}
";
    }

    public function getTemplateName()
    {
        return "@bundles/FormBundle/Form/Type/FormFieldFileType.php";
    }

    public function getDebugInfo()
    {
        return array (  37 => 1,);
    }

    public function getSourceContext()
    {
        return new Source("", "@bundles/FormBundle/Form/Type/FormFieldFileType.php", "/var/www/mautic/app/bundles/FormBundle/Form/Type/FormFieldFileType.php");
    }
}
