<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;

/* @bundles/ReportBundle/Model/ScheduleModel.php */
class __TwigTemplate_ce3db37679812f889ed3189c518ca84ba25067b3099dbf6859a141e80312004e extends Template
{
    private $source;
    private $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = [])
    {
        $macros = $this->macros;
        // line 1
        echo "<?php

namespace Mautic\\ReportBundle\\Model;

use Doctrine\\ORM\\EntityManager;
use Mautic\\ReportBundle\\Entity\\Report;
use Mautic\\ReportBundle\\Entity\\Scheduler;
use Mautic\\ReportBundle\\Entity\\SchedulerRepository;
use Mautic\\ReportBundle\\Scheduler\\Model\\SchedulerPlanner;
use Mautic\\ReportBundle\\Scheduler\\Option\\ExportOption;

class ScheduleModel
{
    /**
     * @var SchedulerRepository
     */
    private \$schedulerRepository;

    /**
     * @var SchedulerPlanner
     */
    private \$schedulerPlanner;

    /**
     * @var EntityManager
     */
    private \$entityManager;

    public function __construct(EntityManager \$entityManager, SchedulerPlanner \$schedulerPlanner)
    {
        \$this->entityManager       = \$entityManager;
        \$this->schedulerRepository = \$entityManager->getRepository(Scheduler::class);
        \$this->schedulerPlanner    = \$schedulerPlanner;
    }

    /**
     * @return Scheduler[]
     */
    public function getScheduledReportsForExport(ExportOption \$exportOption)
    {
        return \$this->schedulerRepository->getScheduledReportsForExport(\$exportOption);
    }

    public function reportWasScheduled(Report \$report)
    {
        \$this->schedulerPlanner->computeScheduler(\$report);
    }

    public function turnOffScheduler(Report \$report): void
    {
        \$report->setIsScheduled(false);
        \$this->entityManager->persist(\$report);
        \$this->entityManager->flush();
    }
}
";
    }

    public function getTemplateName()
    {
        return "@bundles/ReportBundle/Model/ScheduleModel.php";
    }

    public function getDebugInfo()
    {
        return array (  37 => 1,);
    }

    public function getSourceContext()
    {
        return new Source("", "@bundles/ReportBundle/Model/ScheduleModel.php", "/var/www/mautic/app/bundles/ReportBundle/Model/ScheduleModel.php");
    }
}
