<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;

/* @bundles/PointBundle/Controller/Api/PointApiController.php */
class __TwigTemplate_d233c743627f0f15077ede0c7bac4150e5d34684ab5d7721344daffef436a24e extends Template
{
    private $source;
    private $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = [])
    {
        $macros = $this->macros;
        // line 1
        echo "<?php

namespace Mautic\\PointBundle\\Controller\\Api;

use Mautic\\ApiBundle\\Controller\\CommonApiController;
use Mautic\\CoreBundle\\Helper\\InputHelper;
use Mautic\\LeadBundle\\Controller\\LeadAccessTrait;
use Mautic\\LeadBundle\\Model\\LeadModel;
use Symfony\\Component\\HttpFoundation\\Response;
use Symfony\\Component\\HttpKernel\\Event\\FilterControllerEvent;

/**
 * Class PointApiController.
 */
class PointApiController extends CommonApiController
{
    use LeadAccessTrait;

    /**
     * @var LeadModel
     */
    protected \$leadModel;

    /**
     * {@inheritdoc}
     */
    public function initialize(FilterControllerEvent \$event)
    {
        \$this->model            = \$this->getModel('point');
        \$this->leadModel        = \$this->getModel('lead');
        \$this->entityClass      = 'Mautic\\PointBundle\\Entity\\Point';
        \$this->entityNameOne    = 'point';
        \$this->entityNameMulti  = 'points';
        \$this->serializerGroups = ['pointDetails', 'categoryList', 'publishDetails'];

        parent::initialize(\$event);
    }

    /**
     * Return array of available point action types.
     */
    public function getPointActionTypesAction()
    {
        if (!\$this->security->isGranted([\$this->permissionBase.':view', \$this->permissionBase.':viewown'])) {
            return \$this->accessDenied();
        }

        \$actionTypes = \$this->model->getPointActions();
        \$view        = \$this->view(['pointActionTypes' => \$actionTypes['list']]);

        return \$this->handleView(\$view);
    }

    /**
     * Subtract points from a lead.
     *
     * @param int    \$leadId
     * @param string \$operator
     * @param int    \$delta
     *
     * @return \\Symfony\\Component\\HttpFoundation\\Response
     */
    public function adjustPointsAction(\$leadId, \$operator, \$delta)
    {
        \$lead = \$this->checkLeadAccess(\$leadId, 'edit');
        if (\$lead instanceof Response) {
            return \$lead;
        }

        try {
            \$this->logApiPointChange(\$lead, \$delta, \$operator);
        } catch (\\Exception \$e) {
            return \$this->returnError(\$e->getMessage(), Response::HTTP_BAD_REQUEST);
        }

        return \$this->handleView(\$this->view(['success' => 1], Response::HTTP_OK));
    }

    /**
     * Log the lead points change.
     *
     * @param int \$leadId
     * @param int \$delta
     */
    protected function logApiPointChange(\$lead, \$delta, \$operator)
    {
        \$trans      = \$this->get('translator');
        \$ip         = \$this->get('mautic.helper.ip_lookup')->getIpAddress();
        \$eventName  = InputHelper::clean(\$this->request->request->get('eventName', \$trans->trans('mautic.lead.lead.submitaction.operator_'.\$operator)));
        \$actionName = InputHelper::clean(\$this->request->request->get('actionName', \$trans->trans('mautic.lead.event.api')));

        \$lead->adjustPoints(\$delta, \$operator);
        \$lead->addPointsChangeLogEntry('API', \$eventName, \$actionName, \$delta, \$ip);
        \$this->leadModel->saveEntity(\$lead, false);
    }
}
";
    }

    public function getTemplateName()
    {
        return "@bundles/PointBundle/Controller/Api/PointApiController.php";
    }

    public function getDebugInfo()
    {
        return array (  37 => 1,);
    }

    public function getSourceContext()
    {
        return new Source("", "@bundles/PointBundle/Controller/Api/PointApiController.php", "/var/www/mautic/app/bundles/PointBundle/Controller/Api/PointApiController.php");
    }
}
