<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;

/* @bundles/EmailBundle/Validator/EmailOrEmailTokenListValidator.php */
class __TwigTemplate_d0f723a293590454c46da92ccef6867d extends Template
{
    private $source;
    private $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = [])
    {
        $macros = $this->macros;
        // line 1
        echo "<?php

declare(strict_types=1);

namespace Mautic\\EmailBundle\\Validator;

use Mautic\\CoreBundle\\Exception\\InvalidValueException;
use Mautic\\CoreBundle\\Exception\\RecordException;
use Mautic\\CoreBundle\\Form\\DataTransformer\\ArrayStringTransformer;
use Mautic\\EmailBundle\\Exception\\InvalidEmailException;
use Mautic\\EmailBundle\\Helper\\EmailValidator;
use Mautic\\LeadBundle\\DataObject\\ContactFieldToken;
use Mautic\\LeadBundle\\Exception\\InvalidContactFieldTokenException;
use Mautic\\LeadBundle\\Validator\\CustomFieldValidator;
use Symfony\\Component\\Validator\\Constraint;
use Symfony\\Component\\Validator\\ConstraintValidator;
use Symfony\\Component\\Validator\\Exception\\UnexpectedTypeException;

final class EmailOrEmailTokenListValidator extends ConstraintValidator
{
    private EmailValidator \$emailValidator;

    private CustomFieldValidator \$customFieldValidator;

    private ArrayStringTransformer \$transformer;

    public function __construct(
        EmailValidator \$emailValidator,
        CustomFieldValidator \$customFieldValidator
    ) {
        \$this->transformer          = new ArrayStringTransformer();
        \$this->emailValidator       = \$emailValidator;
        \$this->customFieldValidator = \$customFieldValidator;
    }

    /**
     * @return void
     */
    public function validate(\$csv, Constraint \$constraint)
    {
        if (!\$constraint instanceof EmailOrEmailTokenList) {
            throw new UnexpectedTypeException(\$constraint, EmailOrEmailTokenList::class);
        }

        if (null === \$csv || '' === \$csv) {
            return;
        }

        if (!is_string(\$csv)) {
            throw new UnexpectedTypeException(\$csv, 'string');
        }

        array_map(
            \$this->makeEmailOrEmailTokenValidator(),
            \$this->transformer->reverseTransform(\$csv)
        );
    }

    private function makeEmailOrEmailTokenValidator(): callable
    {
        return function (string \$emailOrToken) {
            try {
                // Try to validate if the value is an email address.
                \$this->emailValidator->validate(\$emailOrToken);
            } catch (InvalidEmailException \$emailException) {
                try {
                    // The token syntax is validated during creation of new ContactFieldToken object.
                    \$contactFieldToken = new ContactFieldToken(\$emailOrToken);

                    // Validate that the token default value is a valid email address if set.
                    if (\$contactFieldToken->getDefaultValue()) {
                        \$this->emailValidator->validate(\$contactFieldToken->getDefaultValue());
                    }

                    // Validate that the contact field exists and is type of email.
                    \$this->customFieldValidator->validateFieldType(\$contactFieldToken->getFieldAlias(), 'email');
                } catch (RecordException | InvalidValueException | InvalidContactFieldTokenException \$tokenException) {
                    \$this->context->addViolation(
                        'mautic.email.email_or_token.not_valid',
                        ['%value%' => \$emailOrToken, '%details%' => \$tokenException->getMessage()]
                    );
                }
            }
        };
    }
}
";
    }

    public function getTemplateName()
    {
        return "@bundles/EmailBundle/Validator/EmailOrEmailTokenListValidator.php";
    }

    public function getDebugInfo()
    {
        return array (  37 => 1,);
    }

    public function getSourceContext()
    {
        return new Source("", "@bundles/EmailBundle/Validator/EmailOrEmailTokenListValidator.php", "/var/www/mautic/app/bundles/EmailBundle/Validator/EmailOrEmailTokenListValidator.php");
    }
}
