<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;

/* @bundles/LeadBundle/Model/DoNotContact.php */
class __TwigTemplate_acc153ac0a5ca5b7fefec3193b891c8731e3ef423009ccaa88af74dd16796bf5 extends Template
{
    private $source;
    private $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = [])
    {
        $macros = $this->macros;
        // line 1
        echo "<?php

namespace Mautic\\LeadBundle\\Model;

use Mautic\\LeadBundle\\Entity\\DoNotContact as DNC;
use Mautic\\LeadBundle\\Entity\\DoNotContactRepository;
use Mautic\\LeadBundle\\Entity\\Lead;

class DoNotContact
{
    /**
     * @var LeadModel
     */
    protected \$leadModel;

    /**
     * @var DoNotContactRepository
     */
    protected \$dncRepo;

    /**
     * DoNotContact constructor.
     */
    public function __construct(LeadModel \$leadModel, DoNotContactRepository \$dncRepo)
    {
        \$this->leadModel = \$leadModel;
        \$this->dncRepo   = \$dncRepo;
    }

    /**
     * Remove a Lead's DNC entry based on channel.
     *
     * @param int       \$contactId
     * @param string    \$channel
     * @param bool|true \$persist
     * @param int|null  \$reason
     *
     * @return bool
     */
    public function removeDncForContact(\$contactId, \$channel, \$persist = true, \$reason = null)
    {
        \$contact = \$this->leadModel->getEntity(\$contactId);

        /** @var DNC \$dnc */
        foreach (\$contact->getDoNotContact() as \$dnc) {
            if (\$dnc->getChannel() === \$channel) {
                // Skip if reason doesn't match
                // Some integrations (Sugar CRM) can use both reasons (unsubscribed, bounced)
                if (\$reason && \$dnc->getReason() != \$reason) {
                    continue;
                }
                \$contact->removeDoNotContactEntry(\$dnc);

                if (\$persist) {
                    \$this->leadModel->saveEntity(\$contact);
                }

                return true;
            }
        }

        return false;
    }

    /**
     * Create a DNC entry for a lead.
     *
     * @param int          \$contactId
     * @param string|array \$channel                  If an array with an ID, use the structure ['email' => 123]
     * @param string       \$comments
     * @param int          \$reason                   Must be a class constant from the DoNotContact class
     * @param bool         \$persist
     * @param bool         \$checkCurrentStatus
     * @param bool         \$allowUnsubscribeOverride
     *
     * @return bool|DNC If a DNC entry is added or updated, returns the DoNotContact object. If a DNC is already present
     *                  and has the specified reason, nothing is done and this returns false
     */
    public function addDncForContact(
        \$contactId,
        \$channel,
        \$reason = DNC::BOUNCED,
        \$comments = '',
        \$persist = true,
        \$checkCurrentStatus = true,
        \$allowUnsubscribeOverride = false
    ) {
        \$dnc     = false;
        \$contact = \$this->leadModel->getEntity(\$contactId);

        if (null === \$contact) {
            // Contact not found, nothing to do
            return false;
        }

        // if !\$checkCurrentStatus, assume is contactable due to already being validated
        \$isContactable = (\$checkCurrentStatus) ? \$this->isContactable(\$contact, \$channel) : DNC::IS_CONTACTABLE;

        // If they don't have a DNC entry yet
        if (DNC::IS_CONTACTABLE === \$isContactable) {
            \$dnc = \$this->createDncRecord(\$contact, \$channel, \$reason, \$comments);
        } elseif (\$isContactable !== \$reason) {
            // Or if the given reason is different than the stated reason

            /** @var DNC \$dnc */
            foreach (\$contact->getDoNotContact() as \$dnc) {
                // Only update if the contact did not unsubscribe themselves or if the code forces it
                \$allowOverride = (\$allowUnsubscribeOverride || DNC::UNSUBSCRIBED !== \$dnc->getReason());

                // Only update if the contact did not unsubscribe themselves
                if (\$allowOverride && \$dnc->getChannel() === \$channel) {
                    // Note the outdated entry for listeners
                    \$contact->removeDoNotContactEntry(\$dnc);

                    // Update the entry with the latest
                    \$this->updateDncRecord(\$dnc, \$contact, \$channel, \$reason, \$comments);

                    break;
                }
            }
        }

        if (\$dnc && \$persist) {
            // Use model saveEntity to trigger events for DNC change
            \$this->leadModel->saveEntity(\$contact);
        }

        return \$dnc;
    }

    /**
     * @param string \$channel
     *
     * @return int
     *
     * @see \\Mautic\\LeadBundle\\Entity\\DoNotContact This method can return boolean false, so be
     *                                             sure to always compare the return value against
     *                                             the class constants of DoNotContact
     */
    public function isContactable(Lead \$contact, \$channel)
    {
        if (is_array(\$channel)) {
            \$channel = key(\$channel);
        }

        /** @var \\Mautic\\LeadBundle\\Entity\\DoNotContact[] \$entries */
        \$dncEntries = \$this->dncRepo->getEntriesByLeadAndChannel(\$contact, \$channel);

        // If the lead has no entries in the DNC table, we're good to go
        if (empty(\$dncEntries)) {
            return DNC::IS_CONTACTABLE;
        }

        foreach (\$dncEntries as \$dnc) {
            if (DNC::IS_CONTACTABLE !== \$dnc->getReason()) {
                return \$dnc->getReason();
            }
        }

        return DNC::IS_CONTACTABLE;
    }

    /**
     * @param      \$channel
     * @param      \$reason
     * @param null \$comments
     *
     * @return DNC
     */
    public function createDncRecord(Lead \$contact, \$channel, \$reason, \$comments = null)
    {
        \$dnc = new DNC();

        if (is_array(\$channel)) {
            \$channelId = reset(\$channel);
            \$channel   = key(\$channel);

            \$dnc->setChannelId((int) \$channelId);
        }

        \$dnc->setChannel(\$channel);
        \$dnc->setReason(\$reason);
        \$dnc->setLead(\$contact);
        \$dnc->setDateAdded(new \\DateTime());
        \$dnc->setComments(\$comments);

        \$contact->addDoNotContactEntry(\$dnc);

        return \$dnc;
    }

    /**
     * @param      \$channel
     * @param      \$reason
     * @param null \$comments
     */
    public function updateDncRecord(DNC \$dnc, Lead \$contact, \$channel, \$reason, \$comments = null)
    {
        // Update the DNC entry
        \$dnc->setChannel(\$channel);
        \$dnc->setReason(\$reason);
        \$dnc->setLead(\$contact);
        \$dnc->setDateAdded(new \\DateTime());
        \$dnc->setComments(\$comments);

        // Re-add the entry to the lead
        \$contact->addDoNotContactEntry(\$dnc);
    }

    /**
     * Clear DoNotContact entities from Doctrine UnitOfWork.
     */
    public function clearEntities()
    {
        \$this->dncRepo->clear();
    }

    /**
     * @return DoNotContactRepository
     */
    public function getDncRepo()
    {
        return \$this->dncRepo;
    }
}
";
    }

    public function getTemplateName()
    {
        return "@bundles/LeadBundle/Model/DoNotContact.php";
    }

    public function getDebugInfo()
    {
        return array (  37 => 1,);
    }

    public function getSourceContext()
    {
        return new Source("", "@bundles/LeadBundle/Model/DoNotContact.php", "/var/www/mautic/app/bundles/LeadBundle/Model/DoNotContact.php");
    }
}
