<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;

/* @bundles/CoreBundle/IpLookup/AbstractMaxmindLookup.php */
class __TwigTemplate_1fc752fa6383fed8b31673c3b700d46d9ddcd35e2c88ab2022a36b18298afd30 extends Template
{
    private $source;
    private $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = [])
    {
        $macros = $this->macros;
        // line 1
        echo "<?php

namespace Mautic\\CoreBundle\\IpLookup;

abstract class AbstractMaxmindLookup extends AbstractRemoteDataLookup
{
    /**
     * @return string
     */
    public function getAttribution()
    {
        return '<a href=\"https://www.maxmind.com/en/geoip2-precision-services\" target=\"_blank\">MaxMind Precision Services</a> is a pay per query lookup service that offers solutions with multiple levels of accuracy and details.';
    }

    abstract protected function getName(): string;

    /**
     * @return array
     */
    protected function getHeaders()
    {
        return ['Authorization' => 'Basic '.base64_encode(\$this->auth)];
    }

    /**
     * @return string
     */
    protected function getUrl()
    {
        \$url = 'https://geoip.maxmind.com/geoip/v2.1/';

        switch (\$this->getName()) {
            case 'maxmind_country':
                \$url .= 'country';
                break;
            case 'maxmind_precision':
                \$url .= 'city';
                break;
            case 'maxmind_omni':
                \$url .= 'insights';
                break;
        }

        return \$url.\"/{\$this->ip}\";
    }

    /**
     * @param \$response
     */
    protected function parseResponse(\$response)
    {
        \$data = json_decode(\$response);

        if (\$data) {
            if (empty(\$data->error)) {
                if (isset(\$data->postal)) {
                    \$this->zipcode = \$data->postal->code;
                }
                if (isset(\$data->country)) {
                    \$this->country = \$data->country->names->en;
                }
                if (isset(\$data->city)) {
                    \$this->city    = \$data->city->names->en;
                }

                if (isset(\$data->subdivisions[0])) {
                    if (count(\$data->subdivisions) > 1) {
                        // Use the first listed as the country and second as state
                        // UK -> England -> Winchester
                        \$this->country = \$data->subdivisions[0]->names->en;
                        \$this->region  = \$data->subdivisions[1]->names->en;
                    } else {
                        \$this->region = \$data->subdivisions[0]->names->en;
                    }
                }

                \$this->latitude  = \$data->location->latitude;
                \$this->longitude = \$data->location->longitude;
                \$this->timezone  = \$data->location->time_zone;

                if (isset(\$data->traits->isp)) {
                    \$this->isp = \$data->traits->isp;
                }

                if (isset(\$data->traits->organization)) {
                    \$this->organization = \$data->traits->organization;
                }
            } elseif (null !== \$this->logger) {
                \$this->logger->warning('IP LOOKUP: '.\$data->error);
            }
        }
    }
}
";
    }

    public function getTemplateName()
    {
        return "@bundles/CoreBundle/IpLookup/AbstractMaxmindLookup.php";
    }

    public function getDebugInfo()
    {
        return array (  37 => 1,);
    }

    public function getSourceContext()
    {
        return new Source("", "@bundles/CoreBundle/IpLookup/AbstractMaxmindLookup.php", "/var/www/mautic/app/bundles/CoreBundle/IpLookup/AbstractMaxmindLookup.php");
    }
}
