<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;

/* @bundles/CoreBundle/Form/RequestTrait.php */
class __TwigTemplate_2a394e39ac26e3ca6d8b81bc62f67631e3fec073a0801ae6cb5f8c35ecee078e extends Template
{
    private $source;
    private $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = [])
    {
        $macros = $this->macros;
        // line 1
        echo "<?php

namespace Mautic\\CoreBundle\\Form;

use Mautic\\CoreBundle\\Form\\Type\\BooleanType;
use Mautic\\CoreBundle\\Form\\Type\\CountryType;
use Mautic\\CoreBundle\\Form\\Type\\LocaleType;
use Mautic\\CoreBundle\\Form\\Type\\MultiselectType;
use Mautic\\CoreBundle\\Form\\Type\\RegionType;
use Mautic\\CoreBundle\\Form\\Type\\SelectType;
use Mautic\\CoreBundle\\Form\\Type\\TimezoneType;
use Mautic\\CoreBundle\\Form\\Type\\YesNoButtonGroupType;
use Mautic\\CoreBundle\\Helper\\ArrayHelper;
use Mautic\\CoreBundle\\Helper\\InputHelper;
use Symfony\\Component\\Form\\Extension\\Core\\Type\\ChoiceType;
use Symfony\\Component\\Form\\Extension\\Core\\Type\\DateTimeType;
use Symfony\\Component\\Form\\Extension\\Core\\Type\\DateType;
use Symfony\\Component\\Form\\Extension\\Core\\Type\\TimeType;
use Symfony\\Component\\Form\\Form;
use Symfony\\Component\\Form\\ResolvedFormTypeInterface;

trait RequestTrait
{
    protected function prepareParametersFromRequest(Form \$form, array &\$params, \$entity = null, \$masks = [], \$fields = [])
    {
        // ungroup fields if need it
        foreach (\$fields as \$key=>\$field) {
            if (is_array(\$field)) {
                foreach (\$field as \$k=>\$f) {
                    \$fields[\$k]=\$f;
                }
                unset(\$fields[\$key]);
                continue;
            }
        }

        // Special handling of some fields
        foreach (\$form as \$name => \$child) {
            if (!isset(\$params[\$name])) {
                continue;
            }

            \$type = \$child->getConfig()->getType();
            if (\$type instanceof ResolvedFormTypeInterface) {
                \$type = \$type->getInnerType();
            }
            switch (get_class(\$type)) {
                case YesNoButtonGroupType::class:
                case BooleanType::class:
                    if (!is_object(\$entity)) {
                        break;
                    }

                    \$setter = 'set'.ucfirst(\$name);
                    // Symfony fails to recognize true values on PATCH and add support for all boolean types (on, off, true, false, 1, 0)
                    // If value is array and count 1, return value of array as string
                    if (is_array(\$params[\$name]) && 1 == count(\$params[\$name])) {
                        \$params[\$name] = end(\$params[\$name]);
                    }

                    if ('' === \$params[\$name]) {
                        break;
                    }

                    // find property by value
                    if (!empty(\$fields)) {
                        \$properties = ArrayHelper::getValue('properties', \$fields[\$name]);
                        if (is_array(\$properties)) {
                            \$valuesAsKeys = array_flip(array_values(\$properties));
                            if (isset(\$valuesAsKeys[\$params[\$name]])) {
                                \$params[\$name] = \$valuesAsKeys[\$params[\$name]];
                            }
                        }
                    }

                    \$data = filter_var(\$params[\$name], FILTER_VALIDATE_BOOLEAN);
                    \$data = (bool) \$data;
                    try {
                        \$entity->\$setter(\$data);
                        // Manually handled so remove from form processing
                        unset(\$form[\$name], \$params[\$name]);
                        break;
                    } catch (\\InvalidArgumentException \$exception) {
                    }

                    // If not manually handled cast to int because Symfony form processing take false as empty
                    \$params[\$name] = (int) \$data;

                    break;
                case ChoiceType::class:
                case CountryType::class:
                case LocaleType::class:
                case MultiselectType::class:
                case RegionType::class:
                case SelectType::class:
                case TimezoneType::class:
                    if (!\$child->getConfig()->getOption('multiple')) {
                        break;
                    }

                    // Ensure the value is an array
                    if (!is_array(\$params[\$name])) {
                        \$params[\$name] = (false !== strpos(\$params[\$name], '|')) ? explode('|', \$params[\$name]) : (\$params[\$name] ? [\$params[\$name]] : []);
                    }

                    break;
                case DateTimeType::class:
                case DateType::class:
                case TimeType::class:
                    // Prevent zero based date placeholders
                    \$dateTest = (int) str_replace(['/', '-', ' '], '', \$params[\$name]);

                    if (!\$dateTest) {
                        // Date placeholder was used so just ignore it to allow import of the field
                        unset(\$params[\$name]);
                        break;
                    }

                    if (false === (\$timestamp = strtotime(\$params[\$name]))) {
                        \$timestamp = null;
                    }

                    if (!\$timestamp) {
                        unset(\$params[\$name]);
                        break;
                    }

                    switch (\$type) {
                        case DateTimeType::class:
                            \$params[\$name] = (new \\DateTime(date('Y-m-d H:i:s', \$timestamp)))->format('Y-m-d H:i');
                            break;
                        case DateType::class:
                            \$params[\$name] = (new \\DateTime(date('Y-m-d', \$timestamp)))->format('Y-m-d');
                            break;
                        case TimeType::class:
                            \$params[\$name] = (new \\DateTime(date('H:i:s', \$timestamp)))->format('H:i:s');
                            break;
                    }

                    break;
            }
        }

        if (!isset(\$masks['description'])) {
            // Add description to support strict HTML
            \$masks['description'] = 'strict_html';
        }

        if (!isset(\$masks['content'])) {
            // Assume HTML
            \$masks['description'] = 'html';
        }

        \$params = InputHelper::_(\$params, \$masks);
    }

    /**
     * @param \$fieldData
     * @param \$leadField
     */
    public function cleanFields(&\$fieldData, \$leadField)
    {
        // This will catch null values or non-existent values to prevent null from converting to false/0
        if (!isset(\$fieldData[\$leadField['alias']])) {
            return;
        }

        switch (\$leadField['type']) {
            case 'boolean':
                \$fieldData[\$leadField['alias']] = InputHelper::boolean(\$fieldData[\$leadField['alias']]);
                break;
            // Ensure date/time entries match what symfony expects
            case 'datetime':
            case 'date':
            case 'time':
                // Prevent zero based date placeholders
                \$dateTest = (int) str_replace(['/', '-', ' '], '', \$fieldData[\$leadField['alias']]);
                if (!\$dateTest) {
                    // Date placeholder was used so just ignore it to allow import of the field
                    unset(\$fieldData[\$leadField['alias']]);
                } else {
                    if (false === (\$timestamp = strtotime(\$fieldData[\$leadField['alias']]))) {
                        \$timestamp = null;
                    }
                    if (\$timestamp) {
                        switch (\$leadField['type']) {
                            case 'datetime':
                                \$fieldData[\$leadField['alias']] = (new \\DateTime(date('Y-m-d H:i:s', \$timestamp)))->format('Y-m-d H:i:s');
                                break;
                            case 'date':
                                \$fieldData[\$leadField['alias']] = (new \\DateTime(date('Y-m-d', \$timestamp)))->format('Y-m-d');
                                break;
                            case 'time':
                                \$fieldData[\$leadField['alias']] = (new \\DateTime(date('H:i:s', \$timestamp)))->format('H:i:s');
                                break;
                        }
                    }
                }
                break;
            case 'multiselect':
                if (!is_array(\$fieldData[\$leadField['alias']])) {
                    if (false !== strpos(\$fieldData[\$leadField['alias']], '|')) {
                        \$fieldData[\$leadField['alias']] = explode('|', \$fieldData[\$leadField['alias']]);
                    } else {
                        \$fieldData[\$leadField['alias']] = [\$fieldData[\$leadField['alias']]];
                    }
                }
                break;
            case 'number':
                \$fieldData[\$leadField['alias']] = (float) \$fieldData[\$leadField['alias']];
                break;
            case 'email':
                \$fieldData[\$leadField['alias']] = InputHelper::email(\$fieldData[\$leadField['alias']]);
                break;
        }
    }
}
";
    }

    public function getTemplateName()
    {
        return "@bundles/CoreBundle/Form/RequestTrait.php";
    }

    public function getDebugInfo()
    {
        return array (  37 => 1,);
    }

    public function getSourceContext()
    {
        return new Source("", "@bundles/CoreBundle/Form/RequestTrait.php", "/var/www/mautic/app/bundles/CoreBundle/Form/RequestTrait.php");
    }
}
