<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;

/* @bundles/EmailBundle/Controller/Api/EmailApiController.php */
class __TwigTemplate_73d399fe6602d2715c441dc41481a07f997b4512a2a5adf91c18c49d211c3814 extends Template
{
    private $source;
    private $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = [])
    {
        $macros = $this->macros;
        // line 1
        echo "<?php

namespace Mautic\\EmailBundle\\Controller\\Api;

use Doctrine\\ORM\\EntityNotFoundException;
use Mautic\\ApiBundle\\Controller\\CommonApiController;
use Mautic\\CoreBundle\\Helper\\InputHelper;
use Mautic\\CoreBundle\\Helper\\RandomHelper\\RandomHelperInterface;
use Mautic\\EmailBundle\\MonitoredEmail\\Processor\\Reply;
use Mautic\\LeadBundle\\Controller\\LeadAccessTrait;
use Mautic\\LeadBundle\\Entity\\Lead;
use Symfony\\Component\\HttpFoundation\\Response;
use Symfony\\Component\\HttpKernel\\Event\\FilterControllerEvent;

class EmailApiController extends CommonApiController
{
    use LeadAccessTrait;

    public function initialize(FilterControllerEvent \$event)
    {
        \$this->model            = \$this->getModel('email');
        \$this->entityClass      = 'Mautic\\EmailBundle\\Entity\\Email';
        \$this->entityNameOne    = 'email';
        \$this->entityNameMulti  = 'emails';
        \$this->serializerGroups = ['emailDetails', 'categoryList', 'publishDetails', 'assetList', 'formList', 'leadListList'];
        \$this->dataInputMasks   = [
            'customHtml'     => 'html',
            'dynamicContent' => [
                'content' => 'html',
                'filters' => [
                    'content' => 'html',
                ],
            ],
        ];

        parent::initialize(\$event);
    }

    /**
     * Obtains a list of emails.
     *
     * @return Response
     */
    public function getEntitiesAction()
    {
        //get parent level only
        \$this->listFilters[] = [
            'column' => 'e.variantParent',
            'expr'   => 'isNull',
        ];

        return parent::getEntitiesAction();
    }

    /**
     * Sends the email to it's assigned lists.
     *
     * @param int \$id Email ID
     *
     * @return Response
     *
     * @throws \\Symfony\\Component\\HttpKernel\\Exception\\NotFoundHttpException
     */
    public function sendAction(\$id)
    {
        \$entity = \$this->model->getEntity(\$id);

        if (null === \$entity || !\$entity->isPublished()) {
            return \$this->notFound();
        }

        if (!\$this->checkEntityAccess(\$entity)) {
            return \$this->accessDenied();
        }

        \$lists = \$this->request->request->get('lists', null);
        \$limit = \$this->request->request->get('limit', null);

        list(\$count, \$failed) = \$this->model->sendEmailToLists(\$entity, \$lists, \$limit);

        \$view = \$this->view(
            [
                'success'          => 1,
                'sentCount'        => \$count,
                'failedRecipients' => \$failed,
            ],
            Response::HTTP_OK
        );

        return \$this->handleView(\$view);
    }

    /**
     * Sends the email to a specific lead.
     *
     * @param int \$id     Email ID
     * @param int \$leadId Lead ID
     *
     * @return Response
     *
     * @throws \\Symfony\\Component\\HttpKernel\\Exception\\NotFoundHttpException
     */
    public function sendLeadAction(\$id, \$leadId)
    {
        \$entity = \$this->model->getEntity(\$id);
        if (null !== \$entity) {
            if (!\$this->checkEntityAccess(\$entity)) {
                return \$this->accessDenied();
            }

            /** @var Lead \$lead */
            \$lead = \$this->checkLeadAccess(\$leadId, 'edit');
            if (\$lead instanceof Response) {
                return \$lead;
            }

            \$post       = \$this->request->request->all();
            \$tokens     = (!empty(\$post['tokens'])) ? \$post['tokens'] : [];
            \$assetsIds  = (!empty(\$post['assetAttachments'])) ? \$post['assetAttachments'] : [];
            \$response   = ['success' => false];

            \$cleanTokens = [];

            foreach (\$tokens as \$token => \$value) {
                \$value = InputHelper::clean(\$value);
                if (!preg_match('/^{.*?}\$/', \$token)) {
                    \$token = '{'.\$token.'}';
                }

                \$cleanTokens[\$token] = \$value;
            }

            \$leadFields = array_merge(['id' => \$leadId], \$lead->getProfileFields());
            // Set owner_id to support the \"Owner is mailer\" feature
            if (\$lead->getOwner()) {
                \$leadFields['owner_id'] = \$lead->getOwner()->getId();
            }

            \$result = \$this->model->sendEmail(
                \$entity,
                \$leadFields,
                [
                    'source'            => ['api', 0],
                    'tokens'            => \$cleanTokens,
                    'assetAttachments'  => \$assetsIds,
                    'return_errors'     => true,
                ]
            );

            if (is_bool(\$result)) {
                \$response['success'] = \$result;
            } else {
                \$response['failed'] = \$result;
            }

            \$view = \$this->view(\$response, Response::HTTP_OK);

            return \$this->handleView(\$view);
        }

        return \$this->notFound();
    }

    /**
     * @param string \$trackingHash
     *
     * @return Response
     */
    public function replyAction(\$trackingHash)
    {
        /** @var Reply \$replyService */
        \$replyService = \$this->get('mautic.message.processor.replier');

        /** @var RandomHelperInterface \$randomHelper */
        \$randomHelper = \$this->get('mautic.helper.random');

        try {
            \$replyService->createReplyByHash(\$trackingHash, \"api-{\$randomHelper->generate()}\");
        } catch (EntityNotFoundException \$e) {
            return \$this->notFound(\$e->getMessage());
        }

        return \$this->handleView(
            \$this->view(['success' => true], Response::HTTP_CREATED)
        );
    }
}
";
    }

    public function getTemplateName()
    {
        return "@bundles/EmailBundle/Controller/Api/EmailApiController.php";
    }

    public function getDebugInfo()
    {
        return array (  37 => 1,);
    }

    public function getSourceContext()
    {
        return new Source("", "@bundles/EmailBundle/Controller/Api/EmailApiController.php", "/var/www/mautic/app/bundles/EmailBundle/Controller/Api/EmailApiController.php");
    }
}
