<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;

/* @bundles/EmailBundle/Controller/EmailGraphStatsController.php */
class __TwigTemplate_7c4be0246d428e45c6ba386f044558a0 extends Template
{
    private $source;
    private $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = [])
    {
        $macros = $this->macros;
        // line 1
        echo "<?php

namespace Mautic\\EmailBundle\\Controller;

use Mautic\\CoreBundle\\Form\\Type\\DateRangeType;
use Symfony\\Bundle\\FrameworkBundle\\Controller\\Controller;
use Symfony\\Component\\HttpFoundation\\Request;
use Symfony\\Component\\HttpKernel\\Exception\\AccessDeniedHttpException;

class EmailGraphStatsController extends Controller
{
    /**
     * Loads a specific form into the detailed panel.
     *
     * @param int    \$objectId
     * @param bool   \$isVariant
     * @param string \$dateFrom
     * @param string \$dateTo
     *
     * @return \\Symfony\\Component\\HttpFoundation\\JsonResponse|\\Symfony\\Component\\HttpFoundation\\Response
     *
     * @throws \\Exception
     */
    public function viewAction(Request \$request, \$objectId, \$isVariant, \$dateFrom = null, \$dateTo = null)
    {
        /** @var \\Mautic\\EmailBundle\\Model\\EmailModel \$model */
        \$model = \$this->get('mautic.email.model.email');

        /** @var \\Mautic\\EmailBundle\\Entity\\Email \$email */
        \$email = \$model->getEntity(\$objectId);

        // Init the date range filter form
        \$dateRangeValues = ['date_from' => \$dateFrom, 'date_to' => \$dateTo];
        \$action          = \$this->generateUrl('mautic_email_action', ['objectAction' => 'view', 'objectId' => \$objectId]);
        \$dateRangeForm   = \$this->get('form.factory')->create(DateRangeType::class, \$dateRangeValues, ['action' => \$action]);

        if (null === \$email || !\$this->get('mautic.security')->hasEntityAccess(
                'email:emails:viewown',
                'email:emails:viewother',
                \$email->getCreatedBy()
        )) {
            throw new AccessDeniedHttpException();
        }

        //get A/B test information
        list(\$parent, \$children) = \$email->getVariants();

        //get related translations
        list(\$translationParent, \$translationChildren) = \$email->getTranslations();

        // Prepare stats for bargraph
        if (\$chartStatsSource = \$request->query->get('stats', false)) {
            \$includeVariants = ('all' === \$chartStatsSource);
        } else {
            \$includeVariants = ((\$email->isVariant() && \$parent === \$email) || (\$email->isTranslation() && \$translationParent === \$email));
        }

        \$dateFromObject = new \\DateTime(\$dateFrom);
        \$dateToObject   = new \\DateTime(\$dateTo);

        if ('template' === \$email->getEmailType()) {
            \$stats = \$model->getEmailGeneralStats(
                \$email,
                \$includeVariants,
                null,
                \$dateFromObject,
                \$dateToObject
            );
        } else {
            \$stats = \$model->getEmailListStats(
                \$email,
                \$includeVariants,
                \$dateFromObject,
                \$dateToObject
            );
        }

        \$statsDevices = \$model->getEmailDeviceStats(
            \$email,
            \$includeVariants,
            \$dateFromObject,
            \$dateToObject
        );

        return \$this->render(
            'MauticEmailBundle:Email:graph.html.php',
            [
                'email'         => \$email,
                'stats'         => \$stats,
                'statsDevices'  => \$statsDevices,
                'showAllStats'  => \$includeVariants,
                'dateRangeForm' => \$dateRangeForm->createView(),
                'isVariant'     => \$isVariant,
            ]
        );
    }
}
";
    }

    public function getTemplateName()
    {
        return "@bundles/EmailBundle/Controller/EmailGraphStatsController.php";
    }

    public function getDebugInfo()
    {
        return array (  37 => 1,);
    }

    public function getSourceContext()
    {
        return new Source("", "@bundles/EmailBundle/Controller/EmailGraphStatsController.php", "/var/www/mautic/app/bundles/EmailBundle/Controller/EmailGraphStatsController.php");
    }
}
