<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;

/* @bundles/LeadBundle/Segment/Query/Filter/ForeignValueFilterQueryBuilder.php */
class __TwigTemplate_2131e6d04ea0a8dd950203cad4645e943f6e2fa7b2a391cd8da527b9254b7b28 extends Template
{
    private $source;
    private $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = [])
    {
        $macros = $this->macros;
        // line 1
        echo "<?php

namespace Mautic\\LeadBundle\\Segment\\Query\\Filter;

use Mautic\\LeadBundle\\Segment\\ContactSegmentFilter;
use Mautic\\LeadBundle\\Segment\\Query\\QueryBuilder;

class ForeignValueFilterQueryBuilder extends BaseFilterQueryBuilder
{
    public static function getServiceId()
    {
        return 'mautic.lead.query.builder.foreign.value';
    }

    public function applyQuery(QueryBuilder \$queryBuilder, ContactSegmentFilter \$filter)
    {
        \$leadsTableAlias = \$queryBuilder->getTableAlias(MAUTIC_TABLE_PREFIX.'leads');
        \$filterOperator  = \$filter->getOperator();

        \$filterParameters = \$filter->getParameterValue();

        if (is_array(\$filterParameters)) {
            \$parameters = [];
            foreach (\$filterParameters as \$filterParameter) {
                \$parameters[] = \$this->generateRandomParameterName();
            }
        } else {
            \$parameters = \$this->generateRandomParameterName();
        }

        \$filterParametersHolder = \$filter->getParameterHolder(\$parameters);

        \$tableAlias = \$this->generateRandomParameterName();

        \$subQueryBuilder = \$queryBuilder->createQueryBuilder(\$queryBuilder->getConnection());

        if (!is_null(\$filter->getWhere())) {
            \$subQueryBuilder->andWhere(str_replace(str_replace(MAUTIC_TABLE_PREFIX, '', \$filter->getTable()).'.', \$tableAlias.'.', \$filter->getWhere()));
        }

        switch (\$filterOperator) {
            case 'empty':
                \$subQueryBuilder->select(\$tableAlias.'.lead_id')
                    ->from(\$filter->getTable(), \$tableAlias);
                \$queryBuilder->addLogic(\$queryBuilder->expr()->notIn(\$leadsTableAlias.'.id', \$subQueryBuilder->getSQL()), \$filter->getGlue());
                break;
            case 'notEmpty':
                \$subQueryBuilder->select(\$tableAlias.'.lead_id')
                    ->from(\$filter->getTable(), \$tableAlias);
                \$queryBuilder->addLogic(
                    \$queryBuilder->expr()->in(\$leadsTableAlias.'.id', \$subQueryBuilder->getSQL()),
                    \$filter->getGlue()
                );
                break;
            case 'notIn':
                \$subQueryBuilder
                    ->select('NULL')->from(\$filter->getTable(), \$tableAlias)
                    ->andWhere(\$tableAlias.'.lead_id = '.\$leadsTableAlias.'.id');

                // The use of NOT EXISTS here requires the use of IN instead of NOT IN to prevent a \"double negative.\"
                // We are not using EXISTS...NOT IN because it results in including everyone who has at least one entry that doesn't
                // match the criteria. For example, with tags, if the contact has the tag in the filter but also another tag, they'll
                // be included in the results which is not what we want.
                \$expression = \$subQueryBuilder->expr()->in(
                    \$tableAlias.'.'.\$filter->getField(),
                    \$filterParametersHolder
                );

                \$subQueryBuilder->andWhere(\$expression);
                \$queryBuilder->addLogic(\$queryBuilder->expr()->notExists(\$subQueryBuilder->getSQL()), \$filter->getGlue());
                break;
            case 'neq':
                \$subQueryBuilder
                    ->select('NULL')->from(\$filter->getTable(), \$tableAlias)
                    ->andWhere(\$tableAlias.'.lead_id = '.\$leadsTableAlias.'.id');

                \$expression = \$subQueryBuilder->expr()->orX(
                    \$subQueryBuilder->expr()->eq(\$tableAlias.'.'.\$filter->getField(), \$filterParametersHolder),
                    \$subQueryBuilder->expr()->isNull(\$tableAlias.'.'.\$filter->getField())
                );

                \$subQueryBuilder->andWhere(\$expression);

                \$queryBuilder->addLogic(\$queryBuilder->expr()->notExists(\$subQueryBuilder->getSQL()), \$filter->getGlue());
                break;
            case 'notLike':
                \$subQueryBuilder
                    ->select('NULL')->from(\$filter->getTable(), \$tableAlias)
                    ->andWhere(\$tableAlias.'.lead_id = '.\$leadsTableAlias.'.id');

                \$expression = \$subQueryBuilder->expr()->orX(
                    \$subQueryBuilder->expr()->isNull(\$tableAlias.'.'.\$filter->getField()),
                    \$subQueryBuilder->expr()->like(\$tableAlias.'.'.\$filter->getField(), \$filterParametersHolder)
                );

                \$subQueryBuilder->andWhere(\$expression);

                \$queryBuilder->addLogic(\$queryBuilder->expr()->notExists(\$subQueryBuilder->getSQL()), \$filter->getGlue());
                break;
            case 'regexp':
            case 'notRegexp':
                \$subQueryBuilder->select(\$tableAlias.'.lead_id')
                    ->from(\$filter->getTable(), \$tableAlias);

                \$not        = ('notRegexp' === \$filterOperator) ? ' NOT' : '';
                \$expression = \$tableAlias.'.'.\$filter->getField().\$not.' REGEXP '.\$filterParametersHolder;

                \$subQueryBuilder->andWhere(\$expression);

                \$queryBuilder->addLogic(
                    \$queryBuilder->expr()->in(\$leadsTableAlias.'.id', \$subQueryBuilder->getSQL()),
                    \$filter->getGlue()
                );
                break;
            default:
                \$subQueryBuilder->select(\$tableAlias.'.lead_id')
                    ->from(\$filter->getTable(), \$tableAlias);

                \$expression = \$subQueryBuilder->expr()->\$filterOperator(
                    \$tableAlias.'.'.\$filter->getField(),
                    \$filterParametersHolder
                );
                \$subQueryBuilder->andWhere(\$expression);

                \$queryBuilder->addLogic(\$queryBuilder->expr()->in(\$leadsTableAlias.'.id', \$subQueryBuilder->getSQL()), \$filter->getGlue());
        }

        \$queryBuilder->setParametersPairs(\$parameters, \$filterParameters);

        return \$queryBuilder;
    }
}
";
    }

    public function getTemplateName()
    {
        return "@bundles/LeadBundle/Segment/Query/Filter/ForeignValueFilterQueryBuilder.php";
    }

    public function getDebugInfo()
    {
        return array (  37 => 1,);
    }

    public function getSourceContext()
    {
        return new Source("", "@bundles/LeadBundle/Segment/Query/Filter/ForeignValueFilterQueryBuilder.php", "/var/www/mautic/app/bundles/LeadBundle/Segment/Query/Filter/ForeignValueFilterQueryBuilder.php");
    }
}
