<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;

/* @bundles/CoreBundle/Templating/Helper/FormatterHelper.php */
class __TwigTemplate_4b6601fc2890bf48fb81f0fee3aac5e6 extends Template
{
    private $source;
    private $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = [])
    {
        $macros = $this->macros;
        // line 1
        echo "<?php

namespace Mautic\\CoreBundle\\Templating\\Helper;

use Mautic\\CoreBundle\\Helper\\InputHelper;
use Mautic\\CoreBundle\\Helper\\Serializer;
use Symfony\\Component\\Templating\\Helper\\Helper;
use Symfony\\Component\\Translation\\TranslatorInterface;

class FormatterHelper extends Helper
{
    /**
     * @var DateHelper
     */
    private \$dateHelper;
    /**
     * @var TranslatorInterface
     */
    private \$translator;

    public function __construct(DateHelper \$dateHelper, TranslatorInterface \$translator)
    {
        \$this->dateHelper = \$dateHelper;
        \$this->translator = \$translator;
    }

    /**
     * Format a string.
     *
     * @param \$val
     * @param string \$type
     * @param bool   \$textOnly
     * @param int    \$round
     *
     * @return string
     */
    public function _(\$val, \$type = 'html', \$textOnly = false, \$round = 1)
    {
        if (empty(\$val) && 'bool' !== \$type) {
            return \$val;
        }

        switch (\$type) {
            case 'array':
                if (!is_array(\$val)) {
                    //assume that it's serialized
                    \$unserialized = Serializer::decode(\$val);
                    if (\$unserialized) {
                        \$val = \$unserialized;
                    }
                }

                \$stringParts = [];
                foreach (\$val as \$v) {
                    if (is_array(\$v)) {
                        \$stringParts = \$this->_(\$v, 'array', \$textOnly, \$round + 1);
                    } else {
                        \$stringParts[] = \$v;
                    }
                }
                if (1 === \$round) {
                    \$string = implode('; ', \$stringParts);
                } else {
                    \$string = implode(', ', \$stringParts);
                }
                break;
            case 'datetime':
                \$string = \$this->dateHelper->toFullConcat(\$val, 'utc');
                break;
            case 'time':
                \$string = \$this->dateHelper->toTime(\$val, 'utc');
                break;
            case 'date':
                \$string = \$this->dateHelper->toDate(\$val, 'utc');
                break;
            case 'url':
                \$string = (\$textOnly) ? \$val : '<a href=\"'.\$val.'\" target=\"_new\">'.\$val.'</a>';
                break;
            case 'email':
                \$string = (\$textOnly) ? \$val : '<a href=\"mailto:'.\$val.'\">'.\$val.'</a>';
                break;
            case 'int':
                \$string = (int) \$val;
                break;
            case 'html':
                \$string = InputHelper::strict_html(\$val);
                break;
            case 'bool':
                \$translate = \$val ? 'mautic.core.yes' : 'mautic.core.no';
                \$string    = \$this->translator->trans(\$translate);
                break;
            default:
                \$string = InputHelper::clean(\$val);
                break;
        }

        return \$string;
    }

    /**
     * Converts array to string with provided delimiter
     * Internally, the method uses conversion to json
     * instead of simple implode to cover multidimensional arrays.
     *
     * @param mixed  \$array
     * @param string \$delimiter
     *
     * @return string
     */
    public function arrayToString(\$array, \$delimiter = ', ')
    {
        if (is_array(\$array)) {
            \$replacements = [
                '{'    => '(',
                '}'    => ')',
                '\"'    => '',
                ','    => \$delimiter,
                '[]'   => 'undefined',
                'null' => 'undefined',
                ':'    => ' = ',
            ];
            \$json = json_encode(\$array);

            return trim(str_replace(array_keys(\$replacements), array_values(\$replacements), \$json), '()[]');
        }

        return \$array;
    }

    /**
     * @param string \$delimeter
     *
     * @return string
     */
    public function simpleArrayToHtml(array \$array, \$delimeter = '<br />')
    {
        \$pairs = [];
        foreach (\$array as \$key => \$value) {
            \$pairs[] = \"\$key: \$value\";
        }

        return implode(\$delimeter, \$pairs);
    }

    /**
     * Takes a simple csv list like 1,2,3,4 and returns as an array.
     *
     * @param \$csv
     *
     * @return array
     */
    public function simpleCsvToArray(\$csv, \$type = null)
    {
        if (!\$csv) {
            return [];
        }

        return array_map(
            function (\$value) use (\$type) {
                \$value = trim(\$value);

                return \$this->_(\$value, \$type);
            },
            explode(',', \$csv)
        );
    }

    /**
     * Takes a string and returns a normalized representation of it.
     *
     * @param \$string string
     *
     * @return string
     */
    public function normalizeStringValue(\$string)
    {
        \$stringIsDate = \\DateTime::createFromFormat('Y-m-d H:i:s', \$string, new \\DateTimeZone('UTC'));

        if (\$stringIsDate && (\$string === \$stringIsDate->format('Y-m-d H:i:s'))) {
            return \$this->_(\$stringIsDate, 'datetime');
        }

        return \$string;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'formatter';
    }
}
";
    }

    public function getTemplateName()
    {
        return "@bundles/CoreBundle/Templating/Helper/FormatterHelper.php";
    }

    public function getDebugInfo()
    {
        return array (  37 => 1,);
    }

    public function getSourceContext()
    {
        return new Source("", "@bundles/CoreBundle/Templating/Helper/FormatterHelper.php", "/var/www/mautic/app/bundles/CoreBundle/Templating/Helper/FormatterHelper.php");
    }
}
