<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;

/* @bundles/PointBundle/Controller/PointController.php */
class __TwigTemplate_2bb32c616624b1201cae0c824be9c389 extends Template
{
    private $source;
    private $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = [])
    {
        $macros = $this->macros;
        // line 1
        echo "<?php

namespace Mautic\\PointBundle\\Controller;

use Mautic\\CoreBundle\\Controller\\AbstractFormController;
use Mautic\\CoreBundle\\Factory\\PageHelperFactoryInterface;
use Mautic\\PointBundle\\Entity\\Point;
use Symfony\\Component\\HttpFoundation\\JsonResponse;
use Symfony\\Component\\HttpFoundation\\Response;

class PointController extends AbstractFormController
{
    /**
     * @param int \$page
     *
     * @return JsonResponse|Response
     */
    public function indexAction(\$page = 1)
    {
        //set some permissions
        \$permissions = \$this->get('mautic.security')->isGranted([
            'point:points:view',
            'point:points:create',
            'point:points:edit',
            'point:points:delete',
            'point:points:publish',
        ], 'RETURN_ARRAY');

        if (!\$permissions['point:points:view']) {
            return \$this->accessDenied();
        }

        \$this->setListFilters();

        /** @var PageHelperFactoryInterface \$pageHelperFacotry */
        \$pageHelperFacotry = \$this->get('mautic.page.helper.factory');
        \$pageHelper        = \$pageHelperFacotry->make('mautic.point', \$page);

        \$limit      = \$pageHelper->getLimit();
        \$start      = \$pageHelper->getStart();
        \$search     = \$this->request->get('search', \$this->get('session')->get('mautic.point.filter', ''));
        \$filter     = ['string' => \$search, 'force' => []];
        \$orderBy    = \$this->get('session')->get('mautic.point.orderby', 'p.name');
        \$orderByDir = \$this->get('session')->get('mautic.point.orderbydir', 'ASC');
        \$points     = \$this->getModel('point')->getEntities([
            'start'      => \$start,
            'limit'      => \$limit,
            'filter'     => \$filter,
            'orderBy'    => \$orderBy,
            'orderByDir' => \$orderByDir,
        ]);

        \$this->get('session')->set('mautic.point.filter', \$search);

        \$count = count(\$points);
        if (\$count && \$count < (\$start + 1)) {
            \$lastPage  = \$pageHelper->countPage(\$count);
            \$returnUrl = \$this->generateUrl('mautic_point_index', ['page' => \$lastPage]);
            \$pageHelper->rememberPage(\$lastPage);

            return \$this->postActionRedirect([
                'returnUrl'       => \$returnUrl,
                'viewParameters'  => ['page' => \$lastPage],
                'contentTemplate' => 'MauticPointBundle:Point:index',
                'passthroughVars' => [
                    'activeLink'    => '#mautic_point_index',
                    'mauticContent' => 'point',
                ],
            ]);
        }

        \$pageHelper->rememberPage(\$page);

        //get the list of actions
        \$actions = \$this->getModel('point')->getPointActions();

        return \$this->delegateView([
            'viewParameters' => [
                'searchValue' => \$search,
                'items'       => \$points,
                'actions'     => \$actions['actions'],
                'page'        => \$page,
                'limit'       => \$limit,
                'permissions' => \$permissions,
                'tmpl'        => \$this->request->isXmlHttpRequest() ? \$this->request->get('tmpl', 'index') : 'index',
            ],
            'contentTemplate' => 'MauticPointBundle:Point:list.html.php',
            'passthroughVars' => [
                'activeLink'    => '#mautic_point_index',
                'mauticContent' => 'point',
                'route'         => \$this->generateUrl('mautic_point_index', ['page' => \$page]),
            ],
        ]);
    }

    /**
     * Generates new form and processes post data.
     *
     * @param \\Mautic\\PointBundle\\Entity\\Point \$entity
     *
     * @return JsonResponse|\\Symfony\\Component\\HttpFoundation\\RedirectResponse|Response
     */
    public function newAction(\$entity = null)
    {
        \$model = \$this->getModel('point');

        if (!(\$entity instanceof Point)) {
            /** @var \\Mautic\\PointBundle\\Entity\\Point \$entity */
            \$entity = \$model->getEntity();
        }

        if (!\$this->get('mautic.security')->isGranted('point:points:create')) {
            return \$this->accessDenied();
        }

        //set the page we came from
        \$page       = \$this->get('session')->get('mautic.point.page', 1);
        \$method     = \$this->request->getMethod();
        \$point      = \$this->request->request->get('point', []);
        \$actionType = 'POST' === \$method ? (\$point['type'] ?? '') : '';
        \$action     = \$this->generateUrl('mautic_point_action', ['objectAction' => 'new']);
        \$actions    = \$model->getPointActions();
        \$form       = \$model->createForm(\$entity, \$this->get('form.factory'), \$action, [
            'pointActions' => \$actions,
            'actionType'   => \$actionType,
        ]);
        \$viewParameters = ['page' => \$page];

        ///Check for a submitted form and process it
        if ('POST' === \$method) {
            \$valid = false;

            if (!\$cancelled = \$this->isFormCancelled(\$form)) {
                if (\$valid = \$this->isFormValid(\$form)) {
                    //form is valid so process the data
                    \$model->saveEntity(\$entity);

                    \$this->addFlash('mautic.core.notice.created', [
                        '%name%'      => \$entity->getName(),
                        '%menu_link%' => 'mautic_point_index',
                        '%url%'       => \$this->generateUrl('mautic_point_action', [
                            'objectAction' => 'edit',
                            'objectId'     => \$entity->getId(),
                        ]),
                    ]);

                    if (\$form->get('buttons')->get('save')->isClicked()) {
                        \$returnUrl = \$this->generateUrl('mautic_point_index', \$viewParameters);
                        \$template  = 'MauticPointBundle:Point:index';
                    } else {
                        //return edit view so that all the session stuff is loaded
                        return \$this->editAction(\$entity->getId(), true);
                    }
                }
            } else {
                \$returnUrl = \$this->generateUrl('mautic_point_index', \$viewParameters);
                \$template  = 'MauticPointBundle:Point:index';
            }

            if (\$cancelled || (\$valid && \$form->get('buttons')->get('save')->isClicked())) {
                return \$this->postActionRedirect([
                    'returnUrl'       => \$returnUrl,
                    'viewParameters'  => \$viewParameters,
                    'contentTemplate' => \$template,
                    'passthroughVars' => [
                        'activeLink'    => '#mautic_point_index',
                        'mauticContent' => 'point',
                    ],
                ]);
            }
        }

        \$themes = ['MauticPointBundle:FormTheme\\Action'];
        if (\$actionType && !empty(\$actions['actions'][\$actionType]['formTheme'])) {
            \$themes[] = \$actions['actions'][\$actionType]['formTheme'];
        }

        return \$this->delegateView([
            'viewParameters' => [
                'tmpl'    => \$this->request->isXmlHttpRequest() ? \$this->request->get('tmpl', 'index') : 'index',
                'entity'  => \$entity,
                'form'    => \$this->setFormTheme(\$form, 'MauticPointBundle:Point:form.html.php', \$themes),
                'actions' => \$actions['actions'],
            ],
            'contentTemplate' => 'MauticPointBundle:Point:form.html.php',
            'passthroughVars' => [
                'activeLink'    => '#mautic_point_index',
                'mauticContent' => 'point',
                'route'         => \$this->generateUrl('mautic_point_action', [
                        'objectAction' => (!empty(\$valid) ? 'edit' : 'new'), //valid means a new form was applied
                        'objectId'     => \$entity->getId(),
                    ]
                ),
            ],
        ]);
    }

    /**
     * Generates edit form and processes post data.
     *
     * @param int  \$objectId
     * @param bool \$ignorePost
     *
     * @return JsonResponse|\\Symfony\\Component\\HttpFoundation\\RedirectResponse|Response
     */
    public function editAction(\$objectId, \$ignorePost = false)
    {
        \$model  = \$this->getModel('point');
        \$entity = \$model->getEntity(\$objectId);

        //set the page we came from
        \$page = \$this->get('session')->get('mautic.point.page', 1);

        \$viewParameters = ['page' => \$page];

        //set the return URL
        \$returnUrl = \$this->generateUrl('mautic_point_index', ['page' => \$page]);

        \$postActionVars = [
            'returnUrl'       => \$returnUrl,
            'viewParameters'  => \$viewParameters,
            'contentTemplate' => 'MauticPointBundle:Point:index',
            'passthroughVars' => [
                'activeLink'    => '#mautic_point_index',
                'mauticContent' => 'point',
            ],
        ];

        //form not found
        if (null === \$entity) {
            return \$this->postActionRedirect(
                array_merge(\$postActionVars, [
                    'flashes' => [
                        [
                            'type'    => 'error',
                            'msg'     => 'mautic.point.error.notfound',
                            'msgVars' => ['%id%' => \$objectId],
                        ],
                    ],
                ])
            );
        } elseif (!\$this->get('mautic.security')->isGranted('point:points:edit')) {
            return \$this->accessDenied();
        } elseif (\$model->isLocked(\$entity)) {
            //deny access if the entity is locked
            return \$this->isLocked(\$postActionVars, \$entity, 'point');
        }

        \$method     = \$this->request->getMethod();
        \$point      = \$this->request->request->get('point', []);
        \$actionType = 'POST' === \$method ? (\$point['type'] ?? '') : \$entity->getType();

        \$action  = \$this->generateUrl('mautic_point_action', ['objectAction' => 'edit', 'objectId' => \$objectId]);
        \$actions = \$model->getPointActions();
        \$form    = \$model->createForm(\$entity, \$this->get('form.factory'), \$action, [
            'pointActions' => \$actions,
            'actionType'   => \$actionType,
        ]);

        ///Check for a submitted form and process it
        if (!\$ignorePost && 'POST' === \$method) {
            \$valid = false;

            if (!\$cancelled = \$this->isFormCancelled(\$form)) {
                if (\$valid = \$this->isFormValid(\$form)) {
                    //form is valid so process the data
                    \$model->saveEntity(\$entity, \$form->get('buttons')->get('save')->isClicked());

                    \$this->addFlash('mautic.core.notice.updated', [
                        '%name%'      => \$entity->getName(),
                        '%menu_link%' => 'mautic_point_index',
                        '%url%'       => \$this->generateUrl('mautic_point_action', [
                            'objectAction' => 'edit',
                            'objectId'     => \$entity->getId(),
                        ]),
                    ]);

                    if (\$form->get('buttons')->get('save')->isClicked()) {
                        \$returnUrl = \$this->generateUrl('mautic_point_index', \$viewParameters);
                        \$template  = 'MauticPointBundle:Point:index';
                    }
                }
            } else {
                //unlock the entity
                \$model->unlockEntity(\$entity);

                \$returnUrl = \$this->generateUrl('mautic_point_index', \$viewParameters);
                \$template  = 'MauticPointBundle:Point:index';
            }

            if (\$cancelled || (\$valid && \$form->get('buttons')->get('save')->isClicked())) {
                return \$this->postActionRedirect(
                    array_merge(\$postActionVars, [
                        'returnUrl'       => \$returnUrl,
                        'viewParameters'  => \$viewParameters,
                        'contentTemplate' => \$template,
                    ])
                );
            }
        } else {
            //lock the entity
            \$model->lockEntity(\$entity);
        }

        \$themes = ['MauticPointBundle:FormTheme\\Action'];
        if (!empty(\$actions['actions'][\$actionType]['formTheme'])) {
            \$themes[] = \$actions['actions'][\$actionType]['formTheme'];
        }

        return \$this->delegateView([
            'viewParameters' => [
                'tmpl'    => \$this->request->isXmlHttpRequest() ? \$this->request->get('tmpl', 'index') : 'index',
                'entity'  => \$entity,
                'form'    => \$this->setFormTheme(\$form, 'MauticPointBundle:Point:form.html.php', \$themes),
                'actions' => \$actions['actions'],
            ],
            'contentTemplate' => 'MauticPointBundle:Point:form.html.php',
            'passthroughVars' => [
                'activeLink'    => '#mautic_point_index',
                'mauticContent' => 'point',
                'route'         => \$this->generateUrl('mautic_point_action', [
                        'objectAction' => 'edit',
                        'objectId'     => \$entity->getId(),
                    ]
                ),
            ],
        ]);
    }

    /**
     * Clone an entity.
     *
     * @param int \$objectId
     *
     * @return array|JsonResponse|\\Symfony\\Component\\HttpFoundation\\RedirectResponse|Response
     */
    public function cloneAction(\$objectId)
    {
        \$model  = \$this->getModel('point');
        \$entity = \$model->getEntity(\$objectId);

        if (null != \$entity) {
            if (!\$this->get('mautic.security')->isGranted('point:points:create')) {
                return \$this->accessDenied();
            }

            \$entity = clone \$entity;
            \$entity->setIsPublished(false);
        }

        return \$this->newAction(\$entity);
    }

    /**
     * Deletes the entity.
     *
     * @param int \$objectId
     *
     * @return JsonResponse|\\Symfony\\Component\\HttpFoundation\\RedirectResponse
     */
    public function deleteAction(\$objectId)
    {
        \$page      = \$this->get('session')->get('mautic.point.page', 1);
        \$returnUrl = \$this->generateUrl('mautic_point_index', ['page' => \$page]);
        \$flashes   = [];

        \$postActionVars = [
            'returnUrl'       => \$returnUrl,
            'viewParameters'  => ['page' => \$page],
            'contentTemplate' => 'MauticPointBundle:Point:index',
            'passthroughVars' => [
                'activeLink'    => '#mautic_point_index',
                'mauticContent' => 'point',
            ],
        ];

        if ('POST' == \$this->request->getMethod()) {
            \$model  = \$this->getModel('point');
            \$entity = \$model->getEntity(\$objectId);

            if (null === \$entity) {
                \$flashes[] = [
                    'type'    => 'error',
                    'msg'     => 'mautic.point.error.notfound',
                    'msgVars' => ['%id%' => \$objectId],
                ];
            } elseif (!\$this->get('mautic.security')->isGranted('point:points:delete')) {
                return \$this->accessDenied();
            } elseif (\$model->isLocked(\$entity)) {
                return \$this->isLocked(\$postActionVars, \$entity, 'point');
            }

            \$model->deleteEntity(\$entity);

            \$identifier = \$this->get('translator')->trans(\$entity->getName());
            \$flashes[]  = [
                'type'    => 'notice',
                'msg'     => 'mautic.core.notice.deleted',
                'msgVars' => [
                    '%name%' => \$identifier,
                    '%id%'   => \$objectId,
                ],
            ];
        } //else don't do anything

        return \$this->postActionRedirect(
            array_merge(\$postActionVars, [
                'flashes' => \$flashes,
            ])
        );
    }

    /**
     * Deletes a group of entities.
     *
     * @return \\Symfony\\Component\\HttpFoundation\\JsonResponse|\\Symfony\\Component\\HttpFoundation\\RedirectResponse
     */
    public function batchDeleteAction()
    {
        \$page      = \$this->get('session')->get('mautic.point.page', 1);
        \$returnUrl = \$this->generateUrl('mautic_point_index', ['page' => \$page]);
        \$flashes   = [];

        \$postActionVars = [
            'returnUrl'       => \$returnUrl,
            'viewParameters'  => ['page' => \$page],
            'contentTemplate' => 'MauticPointBundle:Point:index',
            'passthroughVars' => [
                'activeLink'    => '#mautic_point_index',
                'mauticContent' => 'point',
            ],
        ];

        if ('POST' == \$this->request->getMethod()) {
            \$model     = \$this->getModel('point');
            \$ids       = json_decode(\$this->request->query->get('ids', '{}'));
            \$deleteIds = [];

            // Loop over the IDs to perform access checks pre-delete
            foreach (\$ids as \$objectId) {
                \$entity = \$model->getEntity(\$objectId);

                if (null === \$entity) {
                    \$flashes[] = [
                        'type'    => 'error',
                        'msg'     => 'mautic.point.error.notfound',
                        'msgVars' => ['%id%' => \$objectId],
                    ];
                } elseif (!\$this->get('mautic.security')->isGranted('point:points:delete')) {
                    \$flashes[] = \$this->accessDenied(true);
                } elseif (\$model->isLocked(\$entity)) {
                    \$flashes[] = \$this->isLocked(\$postActionVars, \$entity, 'point', true);
                } else {
                    \$deleteIds[] = \$objectId;
                }
            }

            // Delete everything we are able to
            if (!empty(\$deleteIds)) {
                \$entities = \$model->deleteEntities(\$deleteIds);

                \$flashes[] = [
                    'type'    => 'notice',
                    'msg'     => 'mautic.point.notice.batch_deleted',
                    'msgVars' => [
                        '%count%' => count(\$entities),
                    ],
                ];
            }
        } //else don't do anything

        return \$this->postActionRedirect(
            array_merge(\$postActionVars, [
                'flashes' => \$flashes,
            ])
        );
    }
}
";
    }

    public function getTemplateName()
    {
        return "@bundles/PointBundle/Controller/PointController.php";
    }

    public function getDebugInfo()
    {
        return array (  37 => 1,);
    }

    public function getSourceContext()
    {
        return new Source("", "@bundles/PointBundle/Controller/PointController.php", "/var/www/mautic/app/bundles/PointBundle/Controller/PointController.php");
    }
}
