<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;

/* @bundles/PageBundle/EventListener/SearchSubscriber.php */
class __TwigTemplate_2bc96c349e32f81106c1bfcc0bbbbf68 extends Template
{
    private $source;
    private $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = [])
    {
        $macros = $this->macros;
        // line 1
        echo "<?php

namespace Mautic\\PageBundle\\EventListener;

use Mautic\\CoreBundle\\CoreEvents;
use Mautic\\CoreBundle\\Event as MauticEvents;
use Mautic\\CoreBundle\\Helper\\TemplatingHelper;
use Mautic\\CoreBundle\\Helper\\UserHelper;
use Mautic\\CoreBundle\\Security\\Permissions\\CorePermissions;
use Mautic\\PageBundle\\Model\\PageModel;
use Symfony\\Component\\EventDispatcher\\EventSubscriberInterface;

class SearchSubscriber implements EventSubscriberInterface
{
    /**
     * @var UserHelper
     */
    private \$userHelper;

    /**
     * @var PageModel
     */
    private \$pageModel;

    /**
     * @var CorePermissions
     */
    private \$security;

    /**
     * @var TemplatingHelper
     */
    private \$templating;

    public function __construct(
        UserHelper \$userHelper,
        PageModel \$pageModel,
        CorePermissions \$security,
        TemplatingHelper \$templating
    ) {
        \$this->userHelper = \$userHelper;
        \$this->pageModel  = \$pageModel;
        \$this->security   = \$security;
        \$this->templating = \$templating;
    }

    /**
     * @return array
     */
    public static function getSubscribedEvents()
    {
        return [
            CoreEvents::GLOBAL_SEARCH      => ['onGlobalSearch', 0],
            CoreEvents::BUILD_COMMAND_LIST => ['onBuildCommandList', 0],
        ];
    }

    public function onGlobalSearch(MauticEvents\\GlobalSearchEvent \$event)
    {
        \$str = \$event->getSearchString();
        if (empty(\$str)) {
            return;
        }

        \$filter = ['string' => \$str, 'force' => []];

        \$permissions = \$this->security->isGranted(
            ['page:pages:viewown', 'page:pages:viewother'],
            'RETURN_ARRAY'
        );
        if (\$permissions['page:pages:viewown'] || \$permissions['page:pages:viewother']) {
            if (!\$permissions['page:pages:viewother']) {
                \$filter['force'][] = [
                    'column' => 'IDENTITY(p.createdBy)',
                    'expr'   => 'eq',
                    'value'  => \$this->userHelper->getUser()->getId(),
                ];
            }

            \$pages = \$this->pageModel->getEntities(
                [
                    'limit'  => 5,
                    'filter' => \$filter,
                ]);

            if (count(\$pages) > 0) {
                \$pageResults = [];

                foreach (\$pages as \$page) {
                    \$pageResults[] = \$this->templating->getTemplating()->renderResponse(
                        'MauticPageBundle:SubscribedEvents\\Search:global.html.php',
                        ['page' => \$page]
                    )->getContent();
                }
                if (count(\$pages) > 5) {
                    \$pageResults[] = \$this->templating->getTemplating()->renderResponse(
                        'MauticPageBundle:SubscribedEvents\\Search:global.html.php',
                        [
                            'showMore'     => true,
                            'searchString' => \$str,
                            'remaining'    => (count(\$pages) - 5),
                        ]
                    )->getContent();
                }
                \$pageResults['count'] = count(\$pages);
                \$event->addResults('mautic.page.pages', \$pageResults);
            }
        }
    }

    public function onBuildCommandList(MauticEvents\\CommandListEvent \$event)
    {
        if (\$this->security->isGranted(['page:pages:viewown', 'page:pages:viewother'], 'MATCH_ONE')) {
            \$event->addCommands(
                'mautic.page.pages',
                \$this->pageModel->getCommandList()
            );
        }
    }
}
";
    }

    public function getTemplateName()
    {
        return "@bundles/PageBundle/EventListener/SearchSubscriber.php";
    }

    public function getDebugInfo()
    {
        return array (  37 => 1,);
    }

    public function getSourceContext()
    {
        return new Source("", "@bundles/PageBundle/EventListener/SearchSubscriber.php", "/var/www/mautic/app/bundles/PageBundle/EventListener/SearchSubscriber.php");
    }
}
