<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;

/* @bundles/WebhookBundle/EventListener/CampaignSubscriber.php */
class __TwigTemplate_4fc7f22b9cb4aeb077447857065ea9a5 extends Template
{
    private $source;
    private $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = [])
    {
        $macros = $this->macros;
        // line 1
        echo "<?php

namespace Mautic\\WebhookBundle\\EventListener;

use Mautic\\CampaignBundle\\CampaignEvents;
use Mautic\\CampaignBundle\\Event as Events;
use Mautic\\CampaignBundle\\Event\\CampaignExecutionEvent;
use Mautic\\WebhookBundle\\Form\\Type\\CampaignEventSendWebhookType;
use Mautic\\WebhookBundle\\Helper\\CampaignHelper;
use Mautic\\WebhookBundle\\WebhookEvents;
use Symfony\\Component\\EventDispatcher\\EventSubscriberInterface;

class CampaignSubscriber implements EventSubscriberInterface
{
    /**
     * @var CampaignHelper
     */
    private \$campaignHelper;

    public function __construct(CampaignHelper \$campaignHelper)
    {
        \$this->campaignHelper = \$campaignHelper;
    }

    /**
     * @return array
     */
    public static function getSubscribedEvents()
    {
        return [
            CampaignEvents::CAMPAIGN_ON_BUILD         => ['onCampaignBuild', 0],
            WebhookEvents::ON_CAMPAIGN_TRIGGER_ACTION => ['onCampaignTriggerAction', 0],
        ];
    }

    /**
     * @return CampaignExecutionEvent
     */
    public function onCampaignTriggerAction(CampaignExecutionEvent \$event)
    {
        if (\$event->checkContext('campaign.sendwebhook')) {
            try {
                \$this->campaignHelper->fireWebhook(\$event->getConfig(), \$event->getLead());
                \$event->setResult(true);
            } catch (\\Exception \$e) {
                \$event->setFailed(\$e->getMessage());
            }
        }
    }

    /**
     * Add event triggers and actions.
     */
    public function onCampaignBuild(Events\\CampaignBuilderEvent \$event)
    {
        \$sendWebhookAction = [
            'label'              => 'mautic.webhook.event.sendwebhook',
            'description'        => 'mautic.webhook.event.sendwebhook_desc',
            'formType'           => CampaignEventSendWebhookType::class,
            'formTypeCleanMasks' => 'clean',
            'eventName'          => WebhookEvents::ON_CAMPAIGN_TRIGGER_ACTION,
        ];
        \$event->addAction('campaign.sendwebhook', \$sendWebhookAction);
    }
}
";
    }

    public function getTemplateName()
    {
        return "@bundles/WebhookBundle/EventListener/CampaignSubscriber.php";
    }

    public function getDebugInfo()
    {
        return array (  37 => 1,);
    }

    public function getSourceContext()
    {
        return new Source("", "@bundles/WebhookBundle/EventListener/CampaignSubscriber.php", "/var/www/mautic/app/bundles/WebhookBundle/EventListener/CampaignSubscriber.php");
    }
}
