<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;

/* @bundles/PointBundle/Entity/Trigger.php */
class __TwigTemplate_7fa101a3b93a137489c00e00ff091bc3560c176bc2a24cf58e71e78be7c01f25 extends Template
{
    private $source;
    private $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = [])
    {
        $macros = $this->macros;
        // line 1
        echo "<?php

namespace Mautic\\PointBundle\\Entity;

use Doctrine\\Common\\Collections\\ArrayCollection;
use Doctrine\\ORM\\Mapping as ORM;
use Mautic\\ApiBundle\\Serializer\\Driver\\ApiMetadataDriver;
use Mautic\\CoreBundle\\Doctrine\\Mapping\\ClassMetadataBuilder;
use Mautic\\CoreBundle\\Entity\\FormEntity;
use Symfony\\Component\\Validator\\Constraints as Assert;
use Symfony\\Component\\Validator\\Mapping\\ClassMetadata;

class Trigger extends FormEntity
{
    /**
     * @var int
     */
    private \$id;

    /**
     * @var string
     */
    private \$name;

    /**
     * @var string
     */
    private \$description;

    /**
     * @var \\DateTime
     */
    private \$publishUp;

    /**
     * @var \\DateTime
     */
    private \$publishDown;

    /**
     * @var int
     */
    private \$points = 0;

    /**
     * @var string
     */
    private \$color = 'a0acb8';

    /**
     * @var bool
     */
    private \$triggerExistingLeads = false;

    /**
     * @var \\Mautic\\CategoryBundle\\Entity\\Category
     **/
    private \$category;

    /**
     * @var ArrayCollection
     */
    private \$events;

    public function __clone()
    {
        \$this->id = null;

        parent::__clone();
    }

    /**
     * Constructor.
     */
    public function __construct()
    {
        \$this->events = new ArrayCollection();
    }

    public static function loadMetadata(ORM\\ClassMetadata \$metadata)
    {
        \$builder = new ClassMetadataBuilder(\$metadata);

        \$builder->setTable('point_triggers')
            ->setCustomRepositoryClass('Mautic\\PointBundle\\Entity\\TriggerRepository');

        \$builder->addIdColumns();

        \$builder->addPublishDates();

        \$builder->addField('points', 'integer');

        \$builder->createField('color', 'string')
            ->length(7)
            ->build();

        \$builder->createField('triggerExistingLeads', 'boolean')
            ->columnName('trigger_existing_leads')
            ->build();

        \$builder->addCategory();

        \$builder->createOneToMany('events', 'TriggerEvent')
            ->setIndexBy('id')
            ->setOrderBy(['order' => 'ASC'])
            ->mappedBy('trigger')
            ->cascadeAll()
            ->fetchExtraLazy()
            ->build();
    }

    public static function loadValidatorMetadata(ClassMetadata \$metadata)
    {
        \$metadata->addPropertyConstraint('name', new Assert\\NotBlank([
            'message' => 'mautic.core.name.required',
        ]));
    }

    /**
     * Prepares the metadata for API usage.
     *
     * @param \$metadata
     */
    public static function loadApiMetadata(ApiMetadataDriver \$metadata)
    {
        \$metadata->setGroupPrefix('trigger')
            ->addListProperties(
                [
                    'id',
                    'name',
                    'category',
                    'description',
                ]
            )
            ->addProperties(
                [
                    'publishUp',
                    'publishDown',
                    'points',
                    'color',
                    'events',
                    'triggerExistingLeads',
                ]
            )
            ->build();
    }

    /**
     * @param string \$prop
     * @param mixed  \$val
     */
    protected function isChanged(\$prop, \$val)
    {
        if ('events' == \$prop) {
            //changes are already computed so just add them
            \$this->changes[\$prop][\$val[0]] = \$val[1];
        } else {
            parent::isChanged(\$prop, \$val);
        }
    }

    /**
     * Get id.
     *
     * @return int
     */
    public function getId()
    {
        return \$this->id;
    }

    /**
     * Set description.
     *
     * @param string \$description
     *
     * @return Trigger
     */
    public function setDescription(\$description)
    {
        \$this->isChanged('description', \$description);
        \$this->description = \$description;

        return \$this;
    }

    /**
     * Get description.
     *
     * @return string
     */
    public function getDescription()
    {
        return \$this->description;
    }

    /**
     * Set name.
     *
     * @param string \$name
     *
     * @return Trigger
     */
    public function setName(\$name)
    {
        \$this->isChanged('name', \$name);
        \$this->name = \$name;

        return \$this;
    }

    /**
     * Get name.
     *
     * @return string
     */
    public function getName()
    {
        return \$this->name;
    }

    /**
     * Add events.
     *
     * @param \$key
     *
     * @return Point
     */
    public function addTriggerEvent(\$key, TriggerEvent \$event)
    {
        if (\$changes = \$event->getChanges()) {
            \$this->isChanged('events', [\$key, \$changes]);
        }
        \$this->events[\$key] = \$event;

        return \$this;
    }

    /**
     * Remove events.
     */
    public function removeTriggerEvent(TriggerEvent \$event)
    {
        \$this->events->removeElement(\$event);
    }

    /**
     * Get events.
     *
     * @return \\Doctrine\\Common\\Collections\\Collection
     */
    public function getEvents()
    {
        return \$this->events;
    }

    /**
     * Set publishUp.
     *
     * @param \\DateTime \$publishUp
     *
     * @return Point
     */
    public function setPublishUp(\$publishUp)
    {
        \$this->isChanged('publishUp', \$publishUp);
        \$this->publishUp = \$publishUp;

        return \$this;
    }

    /**
     * Get publishUp.
     *
     * @return \\DateTime
     */
    public function getPublishUp()
    {
        return \$this->publishUp;
    }

    /**
     * Set publishDown.
     *
     * @param \\DateTime \$publishDown
     *
     * @return Point
     */
    public function setPublishDown(\$publishDown)
    {
        \$this->isChanged('publishDown', \$publishDown);
        \$this->publishDown = \$publishDown;

        return \$this;
    }

    /**
     * Get publishDown.
     *
     * @return \\DateTime
     */
    public function getPublishDown()
    {
        return \$this->publishDown;
    }

    /**
     * @return mixed
     */
    public function getPoints()
    {
        return \$this->points;
    }

    /**
     * @param mixed \$points
     */
    public function setPoints(\$points)
    {
        \$this->isChanged('points', \$points);
        \$this->points = \$points;
    }

    /**
     * @return mixed
     */
    public function getColor()
    {
        return \$this->color;
    }

    /**
     * @param mixed \$color
     */
    public function setColor(\$color)
    {
        \$this->color = \$color;
    }

    /**
     * @return mixed
     */
    public function getTriggerExistingLeads()
    {
        return \$this->triggerExistingLeads;
    }

    /**
     * @param mixed \$triggerExistingLeads
     */
    public function setTriggerExistingLeads(\$triggerExistingLeads)
    {
        \$this->triggerExistingLeads = \$triggerExistingLeads;
    }

    /**
     * @return mixed
     */
    public function getCategory()
    {
        return \$this->category;
    }

    /**
     * @param mixed \$category
     */
    public function setCategory(\$category)
    {
        \$this->category = \$category;
    }
}
";
    }

    public function getTemplateName()
    {
        return "@bundles/PointBundle/Entity/Trigger.php";
    }

    public function getDebugInfo()
    {
        return array (  37 => 1,);
    }

    public function getSourceContext()
    {
        return new Source("", "@bundles/PointBundle/Entity/Trigger.php", "/var/www/mautic/app/bundles/PointBundle/Entity/Trigger.php");
    }
}
