<?php

namespace Mautic\UserBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Mautic\CoreBundle\Doctrine\Mapping\ClassMetadataBuilder;
use Mautic\CoreBundle\Entity\CacheInvalidateInterface;

class Permission implements CacheInvalidateInterface
{
    public const CACHE_NAMESPACE = 'Permission';

    /**
     * @var int
     */
    protected $id;

    /**
     * @var string
     */
    protected $bundle;

    /**
     * @var string
     */
    protected $name;

    /**
     * @var Role
     */
    protected $role;

    /**
     * @var int
     */
    protected $bitwise;

    public static function loadMetadata(ORM\ClassMetadata $metadata): void
    {
        $builder = new ClassMetadataBuilder($metadata);

        $builder->setTable('permissions')
            ->setCustomRepositoryClass(PermissionRepository::class)
            ->addUniqueConstraint(['bundle', 'name', 'role_id'], 'unique_perm');

        $builder->addId();

        $builder->createField('bundle', 'string')
            ->length(50)
            ->build();

        $builder->createField('name', 'string')
            ->length(50)
            ->build();

        $builder->createManyToOne('role', 'Role')
            ->inversedBy('permissions')
            ->addJoinColumn('role_id', 'id', false, false, 'CASCADE')
            ->build();

        $builder->addField('bitwise', 'integer');
    }

    /**
     * Get id.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set bundle.
     *
     * @param string $bundle
     *
     * @return Permission
     */
    public function setBundle($bundle)
    {
        $this->bundle = $bundle;

        return $this;
    }

    /**
     * Get bundle.
     *
     * @return string
     */
    public function getBundle()
    {
        return $this->bundle;
    }

    /**
     * Set bitwise.
     *
     * @param int $bitwise
     *
     * @return Permission
     */
    public function setBitwise($bitwise)
    {
        $this->bitwise = $bitwise;

        return $this;
    }

    /**
     * Get bitwise.
     *
     * @return int
     */
    public function getBitwise()
    {
        return $this->bitwise;
    }

    /**
     * Set role.
     *
     * @return Permission
     */
    public function setRole(Role $role = null)
    {
        $this->role = $role;

        return $this;
    }

    /**
     * Get role.
     *
     * @return Role
     */
    public function getRole()
    {
        return $this->role;
    }

    /**
     * Set name.
     *
     * @param string $name
     *
     * @return Permission
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name.
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    public function getCacheNamespacesToDelete(): array
    {
        return [self::CACHE_NAMESPACE];
    }
}
